create or replace package tbicds.PCK_INSTRUMENT_RESPONSES
AUTHID CURRENT_USER 
is

/* Copyright 2016 Intellica Corporation.  

This software is protected by FAR Subpart 27.4 - Rights in Data and Copyrights and 
international treaties.  The software was produced by Intellica Corporation of 
San Antonio, Texas for the Veterans Administration (VA) under Contract Number 
VA118-14-C-0015, Project Number TAC-16-28335 and Project Title, 
'Traumatic Brain Injury Clinical Decision Support (TBI CDS) Implementation'.  
Contract dates: 8 May 2014 - 4 January 2016.  This software was finalized 
and uploaded to the VA's Open Source Electronic Health Record Alliance (OSEHRA) 
on 31 December 2015.  Unauthorized reproduction or distribution of this software 
or any portion of it may result in severe civil and criminal penalties and will 
be prosecuted to the maximum possible extent of the law.

For licensing information contact:  info@intellicacorp.com 
*/

  function fnGetExportScoreValue(pi_vDataValue  in varchar2,
                                 pi_vStatFilter in varchar2) return varchar2;
                                    
  procedure InsertInstrumentResponse(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vPatientID     in varchar2,
                                     pi_nIntakeID      in number,
                                     pi_nMID           in number,
                                     pi_nTID           in number,
                                     pi_nQID           in number,
                                     pi_nRID           in number,
                                     pi_nScoreValue    in number,
                                     pi_vResponseValue in varchar2,

                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2);

  procedure GetInstrumentResponsesRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vPatientID      in varchar2,
                                     --pi_nSiteID         in number,
                                     --pi_nClinicalProgID in number,
                                     --pi_nPathwayID      in number,
                                     pi_nMID            in number,
                                     pi_nIntakeID       in number,
                                     
                                     rs                out PCK_COMMON.refCursor,
                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2);
                                     
 procedure GetMergedInstrumentResponsesRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vPatientID      in varchar2,
                                     pi_nMID            in number,
                                     pi_nIntakeID       in number,
                                     
                                     rs                out PCK_COMMON.refCursor,
                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2);

  PROCEDURE GetIntakeLogicVarRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vPatientID       in varchar2,
                                pi_vKey             in varchar2,
                                pi_nMID             in number,
                                rs                  out PCK_COMMON.refCursor,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2);

  procedure GetScoreLogicRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_nMID             in number,
                            rs                  out PCK_COMMON.refCursor,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2);

  PROCEDURE GetPatientInstrumentsRS(pi_vSessionID       IN VARCHAR2,
                                    pi_vSessionClientIP IN VARCHAR2,
                                    pi_nUserID          IN NUMBER,
                                    pi_vPatientID       IN VARCHAR2,
                                    rs                  OUT PCK_COMMON.refCursor,
                                    po_nStatusCode      OUT NUMBER,
                                    po_vStatusComment   OUT VARCHAR2);

 procedure RemoveAllResponses(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vPatientID       in varchar2,
                              pi_nMID             in number,
                              pi_nIntakeID        in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2);
                                                                   
 procedure RemovePrevResponses(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vPatientID       in varchar2,
                               pi_nMID             in number,
                               pi_nIntakeID        in number,
                               pi_vResponses       in varchar2,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2); 
                               
 procedure RemoveResponse(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vPatientID       in varchar2,
                          pi_nMID             in number,
                          pi_nIntakeID        in number,
                          pi_nRID             in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2);
                         
  procedure InsertInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID       in varchar2,
                                 pi_nIntakeID        in number,
                                 pi_nMID             in number,
                                 pi_nSeriesID        in number,
                                 pi_nScore           in number,
                                 pi_vInterpret       in varchar2,
                                     
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2);
                                 
 procedure InsertInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID       in varchar2,
                                 pi_nIntakeID        in number,
                                 pi_nMID             in number,
                                 pi_nSeriesID        in number,
                                 pi_nScore           in number,
                                 pi_vInterpret       in varchar2,
                                 pi_vDescription     in varchar2,
                                     
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2);
                                 
 procedure InsertInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID       in varchar2,
                                 pi_nIntakeID        in number,
                                 pi_nMID             in number,
                                 pi_nSeriesID        in number,
                                 pi_nScore           in number,
                                 pi_vInterpret       in varchar2,
                                 pi_vDescription     in varchar2,
                                 pi_nSeverity        in number,
                                     
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2);
                                 
   procedure DeleteInstrumentScore(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP  in varchar2,
                                   pi_nUserID           in number,
                                       
                                   pi_vPatientID        in varchar2,
                                   pi_nIntakeID         in number,
                                   pi_nMID              in number,
                                       
                                   po_nStatusCode       out number,
                                   po_vStatusComment    out varchar2);

  procedure GetInstrumentScoresRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                       
                                  pi_vPatientID       in varchar2,
                                  pi_nMID             in number,
                                  pi_nIntakeID        in number,
                                  pi_nFilter          in number,
                                       
                                  rs                  out PCK_COMMON.refCursor,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2);
                                  
  procedure GetInstrumentScoresRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                       
                                  pi_vPatientID      in varchar2,
                                  pi_nMID            in number,
                                  pi_nIntakeID       in number,
                                       
                                  rs                out PCK_COMMON.refCursor,
                                  po_nStatusCode    out number,
                                  po_vStatusComment out varchar2);
                                   
  procedure GetInstrumentScoresRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                       
                                  pi_vPatientID      in varchar2,
                                  pi_nMID            in number,
                                       
                                  rs                out PCK_COMMON.refCursor,
                                  po_nStatusCode    out number,
                                  po_vStatusComment out varchar2);
                                 
end PCK_INSTRUMENT_RESPONSES;
/

